package ch.frankel.blog.validation.validator;

import static java.lang.annotation.ElementType.ANNOTATION_TYPE;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.Payload;

/**
 * Denotes a field as being capitalized.
 * 
 * @author <a href="http://blog.frankel.ch">Nicolas Frankel</a>
 */
@Target( { METHOD, FIELD, ANNOTATION_TYPE })
@Retention(RUNTIME)
@Constraint(validatedBy = CapitalizedValidator.class)
public @interface Capitalized {

    String message() default "{ch.frankel.blog.validation.constraints.capitalized}";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
